<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

try {
    $pdo = getConnection();
    
    // Drop tabelas existentes
    $pdo->exec("DROP TABLE IF EXISTS marketing_destinatarios");
    $pdo->exec("DROP TABLE IF EXISTS marketing_campanhas");
    
    // Lê e executa o arquivo SQL
    $sql = file_get_contents('../sql/marketing_tables.sql');
    $pdo->exec($sql);
    
    echo json_encode([
        'success' => true,
        'message' => 'Tabelas recriadas com sucesso!'
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
