<?php
require_once '../config/database.php';

// Inicia a sessão se ainda não foi iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

try {
    // Validar dados recebidos
    if (empty($_POST['usuario']) || empty($_POST['senha'])) {
        throw new Exception('dados_invalidos');
    }

    $database = new Database();
    $conn = $database->getConnection();
    
    // Buscar usuário
    $stmt = $conn->prepare("SELECT id, nome, senha, permissoes FROM usuarios WHERE nome = ?");
    $stmt->execute([$_POST['usuario']]);
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$usuario || !password_verify($_POST['senha'], $usuario['senha'])) {
        throw new Exception('credenciais_invalidas');
    }
    
    // Limpar qualquer sessão anterior
    session_regenerate_id(true);
    
    // Criar nova sessão
    $_SESSION['usuario_id'] = $usuario['id'];
    $_SESSION['usuario_nome'] = $usuario['nome'];
    
    // Processar permissões
    $permissoes = json_decode($usuario['permissoes'], true);
    if ($permissoes === null) {
        error_log("DEBUG - Erro ao decodificar permissões do usuário: " . json_last_error_msg());
        $permissoes = [];
    }
    
    // Se for admin, garantir todas as permissões
    if (strtolower($usuario['nome']) === 'admin') {
        $_SESSION['admin'] = true;
        $permissoes = ['dashboard', 'clientes', 'produtos', 'pdv', 'vendas', 'provas', 'relatorios', 'marketing', 'usuarios', 'configuracoes'];
        error_log("DEBUG - Usuário admin: definindo todas as permissões");
    } else {
        $_SESSION['admin'] = false;
    }
    
    $_SESSION['permissoes'] = $permissoes;
    error_log("DEBUG - Permissões definidas para o usuário " . $usuario['nome'] . ": " . json_encode($permissoes));
    
    $_SESSION['ultimo_acesso'] = time();
    
    // Se houver uma URL de redirecionamento, usa ela
    if (isset($_POST['redirect'])) {
        $redirect_url = urldecode($_POST['redirect']);
        // Verifica se a URL é do mesmo domínio
        if (parse_url($redirect_url, PHP_URL_HOST) === null || parse_url($redirect_url, PHP_URL_HOST) === $_SERVER['HTTP_HOST']) {
            header('Location: ' . $redirect_url);
            exit;
        }
    }
    
    // Se não houver redirecionamento, vai para o dashboard
    header('Location: ../index.php');
    exit;
    
} catch (Exception $e) {
    $erro = '2'; // erro genérico
    
    if ($e->getMessage() === 'dados_invalidos') {
        $erro = '1';
    } else if ($e->getMessage() === 'credenciais_invalidas') {
        $erro = '1';
    }
    
    error_log("Erro no login: " . $e->getMessage());
    header('Location: ../login.php?erro=' . $erro);
    exit;
}
?>
