<?php
// Desativa a exibição de erros
error_reporting(0);
ini_set('display_errors', 0);

// Garante que nenhum output foi enviado antes
if (ob_get_length()) ob_clean();

header('Content-Type: application/json');

require_once '../includes/config.php';
require_once '../includes/functions.php';

try {
    if (!isset($_GET['id'])) {
        throw new Exception('ID da venda não fornecido');
    }

    $vendaId = $_GET['id'];
    $pdo = getConnection();
    
    // Busca dados da venda
    $query = "
        SELECT 
            o.id,
            o.tipo,
            o.valor_total,
            o.created_at,
            c.nome as cliente_nome
        FROM operacoes o
        LEFT JOIN clientes c ON c.id = o.cliente_id
        WHERE o.id = ?
        AND o.deleted_at IS NULL
    ";
    $stmt = $pdo->prepare($query);
    $stmt->execute([$vendaId]);
    $venda = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$venda) {
        throw new Exception('Venda não encontrada');
    }
    
    // Busca itens da venda
    $queryItens = "
        SELECT 
            oi.quantidade,
            oi.valor_unitario,
            oi.tamanho,
            p.nome as produto_nome
        FROM operacao_itens oi
        JOIN produtos p ON p.id = oi.produto_id
        WHERE oi.operacao_id = ?
        AND oi.deleted_at IS NULL
    ";
    $stmtItens = $pdo->prepare($queryItens);
    $stmtItens->execute([$vendaId]);
    $itens = $stmtItens->fetchAll(PDO::FETCH_ASSOC);
    
    $venda['itens'] = $itens;
    
    die(json_encode([
        'success' => true,
        'data' => $venda
    ]));

} catch (Exception $e) {
    die(json_encode([
        'success' => false,
        'message' => 'Erro ao buscar detalhes da venda: ' . $e->getMessage()
    ]));
}
