<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

// Ativa exibição de erros para debug
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: application/json');

if (!isset($_GET['prova_id'])) {
    echo json_encode(['success' => false, 'message' => 'ID da prova não fornecido']);
    exit;
}

$prova_id = $_GET['prova_id'];
error_log("Buscando prova ID: " . $prova_id);

try {
    $pdo = getConnection();
    
    // Primeiro, verifica se a operação existe sem filtros
    $stmt = $pdo->prepare("SELECT * FROM operacoes WHERE id = ?");
    $stmt->execute([$prova_id]);
    $operacao = $stmt->fetch(PDO::FETCH_ASSOC);
    
    error_log("Operação encontrada: " . json_encode($operacao));
    
    if (!$operacao) {
        echo json_encode(['success' => false, 'message' => 'Operação não encontrada']);
        exit;
    }

    // Busca informações completas da prova
    $query = "
        SELECT 
            p.*,
            c.id as cliente_id,
            c.nome as cliente_nome 
        FROM operacoes p 
        JOIN clientes c ON p.cliente_id = c.id 
        WHERE p.id = ?
    ";
    error_log("Query prova: " . $query);
    
    $stmt = $pdo->prepare($query);
    $stmt->execute([$prova_id]);
    $prova = $stmt->fetch(PDO::FETCH_ASSOC);

    error_log("Resultado prova: " . json_encode($prova));

    if (!$prova) {
        echo json_encode(['success' => false, 'message' => 'Prova não encontrada com cliente']);
        exit;
    }

    // Busca os itens da prova
    $query = "
        SELECT 
            pi.*,
            p.nome as produto_nome,
            p.valor as valor_unitario
        FROM operacao_itens pi 
        JOIN produtos p ON pi.produto_id = p.id 
        WHERE pi.operacao_id = ?
    ";
    error_log("Query itens: " . $query);
    
    $stmt = $pdo->prepare($query);
    $stmt->execute([$prova_id]);
    $itens = $stmt->fetchAll(PDO::FETCH_ASSOC);

    error_log("Resultado itens: " . json_encode($itens));

    // Formata os dados para garantir tipos corretos
    foreach ($itens as &$item) {
        $item['quantidade'] = intval($item['quantidade']);
        $item['valor_unitario'] = floatval($item['valor_unitario']);
        $item['produto_id'] = intval($item['produto_id']);
    }

    $response = [
        'success' => true,
        'data' => [
            'prova' => [
                'id' => intval($prova['id']),
                'cliente_id' => intval($prova['cliente_id']),
                'cliente_nome' => $prova['cliente_nome'],
                'data_criacao' => $prova['created_at'],
                'status' => 'ativo'
            ],
            'itens' => $itens
        ]
    ];

    echo json_encode($response);

} catch (Exception $e) {
    error_log("Erro em get_prova_para_pdv.php: " . $e->getMessage());
    error_log("Stack trace: " . $e->getTraceAsString());
    
    echo json_encode([
        'success' => false, 
        'message' => 'Erro ao buscar dados da prova: ' . $e->getMessage(),
        'error_details' => [
            'message' => $e->getMessage(),
            'file' => $e->getFile(),
            'line' => $e->getLine()
        ]
    ]);
}
