<?php
require_once '../includes/db_connection.php';

if (isset($_GET['id'])) {
    $id = $_GET['id'];
    
    $query = "SELECT p.nome, t.tamanho, t.estoque 
              FROM produtos p 
              JOIN tamanhos t ON p.id = t.produto_id 
              WHERE p.id = ?";
              
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $tamanhos = [];
    $estoques = [];
    
    while ($row = $result->fetch_assoc()) {
        $tamanhos[] = $row['tamanho'];
        $estoques[] = $row['estoque'];
    }
    
    echo json_encode([
        'tamanhos' => $tamanhos,
        'estoques' => $estoques
    ]);
} else {
    echo json_encode([
        'tamanhos' => [],
        'estoques' => []
    ]);
}
