<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

// Verifica se o ID da venda foi fornecido
$venda_id = filter_input(INPUT_GET, 'venda_id', FILTER_VALIDATE_INT);

if (!$venda_id) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => 'ID da venda não fornecido'
    ]);
    exit;
}

try {
    $pdo = getConnection();
    
    // Busca os pagamentos diretamente
    $stmt = $pdo->prepare("
        SELECT 
            DATE_FORMAT(data_pagamento, '%d/%m/%Y %H:%i') as data_pagamento,
            valor
        FROM pagamentos_parciais
        WHERE venda_id = ?
        ORDER BY data_pagamento DESC
    ");
    
    $stmt->execute([$venda_id]);
    $pagamentos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'success' => true,
        'data' => $pagamentos
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
