<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

try {
    $db = getConnection();
    
    $stmt = $db->query("SELECT site_ativo FROM config_site LIMIT 1");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($result === false) {
        // Se não encontrou registro, retorna desativado
        $site_ativo = false;
    } else {
        // Converte para booleano (0 = false, qualquer outro valor = true)
        $site_ativo = $result['site_ativo'] == 1;
    }
    
    echo json_encode([
        'success' => true,
        'site_ativo' => $site_ativo
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
