<?php
// Desativa a exibição de erros
error_reporting(0);
ini_set('display_errors', 0);

// Garante que nenhum output foi enviado antes
if (ob_get_length()) ob_clean();

require_once '../includes/config.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

try {
    $pdo = getConnection();
    
    $query = "SELECT * FROM config_empresa LIMIT 1";
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $config = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$config) {
        // Se não houver configurações, retorna valores padrão
        $config = [
            'nome_empresa' => 'MINHA LOJA',
            'cnpj' => '',
            'telefone' => '',
            'whatsapp' => '',
            'email' => '',
            'instagram' => '',
            'endereco' => ''
        ];
    }
    
    die(json_encode([
        'success' => true,
        'config' => [
            'nome_empresa' => $config['nome_empresa'],
            'cnpj' => $config['cnpj'],
            'telefone' => $config['telefone'],
            'whatsapp' => $config['whatsapp'],
            'email' => $config['email'],
            'instagram' => $config['instagram'],
            'endereco' => $config['endereco']
        ]
    ]));
    
} catch (Exception $e) {
    error_log("Erro ao buscar configurações da empresa: " . $e->getMessage());
    die(json_encode([
        'success' => false,
        'message' => 'Erro ao buscar configurações da empresa'
    ]));
}
