<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

try {
    $pdo = getConnection();
    
    $stmt = $pdo->query("SELECT id, nome FROM categorias WHERE deleted_at IS NULL ORDER BY nome");
    $categorias = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'data' => $categorias
    ]);

} catch (Exception $e) {
    error_log("Erro ao buscar categorias: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar categorias'
    ]);
}
