<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

try {
    $pdo = getConnection();
    
    // Primeiro, vamos verificar se a conexão está funcionando
    if (!$pdo) {
        throw new Exception("Erro na conexão com o banco de dados");
    }
    
    // Primeiro verifica se a tabela existe
    $tableExists = $pdo->query("SHOW TABLES LIKE 'marketing_campanhas'")->rowCount() > 0;
    
    if (!$tableExists) {
        throw new Exception("A tabela marketing_campanhas não existe. Por favor, execute o script de criação das tabelas.");
    }
    
    $query = "
        SELECT 
            c.id,
            c.nome,
            c.descricao,
            c.imagem,
            DATE_FORMAT(c.data_envio, '%d/%m/%Y %H:%i') as data_envio,
            c.status,
            COUNT(d.id) as clientes_alcancados
        FROM marketing_campanhas c
        LEFT JOIN marketing_destinatarios d ON d.campanha_id = c.id
        WHERE c.deleted_at IS NULL
        GROUP BY c.id, c.nome, c.descricao, c.imagem, c.data_envio, c.status
        ORDER BY c.data_envio DESC
    ";
    
    $stmt = $pdo->query($query);
    
    if (!$stmt) {
        throw new Exception("Erro ao executar a query: " . print_r($pdo->errorInfo(), true));
    }
    
    $campanhas = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'data' => $campanhas
    ]);

} catch (Exception $e) {
    error_log("Erro em get_campanhas.php: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
