<?php
require_once '../includes/config.php';

// Verifica se a extensão GD está instalada
if (!extension_loaded('gd')) {
    die("A extensão GD do PHP não está instalada. Por favor, habilite-a no php.ini");
}

try {
    $db = getConnection();
    $query = "SELECT logo FROM config_empresa WHERE id = 1";
    $stmt = $db->prepare($query);
    if ($stmt->execute()) {
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($result && !empty($result['logo'])) {
            $logo_path = __DIR__ . '/../' . $result['logo'];
            
            if (file_exists($logo_path)) {
                // Detecta o tipo de imagem
                $image_info = getimagesize($logo_path);
                if ($image_info === false) {
                    die("Erro: Arquivo não é uma imagem válida");
                }

                // Carrega a imagem baseado no tipo
                switch ($image_info[2]) {
                    case IMAGETYPE_JPEG:
                        $source = imagecreatefromjpeg($logo_path);
                        break;
                    case IMAGETYPE_PNG:
                        $source = imagecreatefrompng($logo_path);
                        break;
                    default:
                        die("Tipo de imagem não suportado. Use JPG ou PNG.");
                }

                if ($source) {
                    // Cria uma nova imagem 32x32
                    $favicon = imagecreatetruecolor(32, 32);
                    // Define fundo transparente
                    imagealphablending($favicon, false);
                    imagesavealpha($favicon, true);
                    $transparent = imagecolorallocatealpha($favicon, 255, 255, 255, 127);
                    imagefilledrectangle($favicon, 0, 0, 32, 32, $transparent);
                    // Redimensiona
                    imagecopyresampled($favicon, $source, 0, 0, 0, 0, 32, 32, imagesx($source), imagesy($source));
                    // Salva como PNG
                    imagepng($favicon, __DIR__ . '/../favicon.png');
                    // Libera a memória
                    imagedestroy($source);
                    imagedestroy($favicon);
                    
                    echo "Favicon gerado com sucesso!";
                } else {
                    echo "Erro ao carregar a imagem original.";
                }
            } else {
                echo "Arquivo da logo não encontrado em: " . $logo_path;
            }
        } else {
            echo "Logo não configurada na tabela config_empresa.";
        }
    }
} catch (Exception $e) {
    echo "Erro ao gerar favicon: " . $e->getMessage();
}
