<?php
require_once '../includes/config.php';
require_once '../includes/conexao.php';

// Verifica se o usuário está logado
session_start();
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../admin/login.php');
    exit;
}

try {
    // Verifica se o caixa existe e está aberto
    $stmt = $pdo->prepare("SELECT id, valor_abertura, data_abertura FROM caixa WHERE id = ? AND status = 'aberto'");
    $stmt->execute([$_POST['caixa_id']]);
    $caixa = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$caixa) {
        throw new Exception('Caixa não encontrado ou já está fechado');
    }

    // Calcula o valor total em caixa
    $valor_total = $caixa['valor_abertura'];

    // Soma vendas desde a abertura do caixa
    $stmt = $pdo->prepare("
        SELECT COALESCE(SUM(valor_total), 0) as total_vendas 
        FROM vendas 
        WHERE data_venda >= ?
    ");
    $stmt->execute([$caixa['data_abertura']]);
    $total_vendas = $stmt->fetch(PDO::FETCH_ASSOC);
    $valor_total += $total_vendas['total_vendas'];

    // Soma recebimentos do crediário desde a abertura do caixa
    $stmt = $pdo->prepare("
        SELECT COALESCE(SUM(valor_pago), 0) as total_crediario 
        FROM pagamentos_crediario 
        WHERE data_pagamento >= ?
    ");
    $stmt->execute([$caixa['data_abertura']]);
    $total_crediario = $stmt->fetch(PDO::FETCH_ASSOC);
    $valor_total += $total_crediario['total_crediario'];

    // Valida o valor de fechamento
    if (!isset($_POST['valor_fechamento']) || !is_numeric($_POST['valor_fechamento'])) {
        throw new Exception('Valor de fechamento inválido');
    }

    // Atualiza o registro
    $stmt = $pdo->prepare("UPDATE caixa SET status = 'fechado', valor_fechamento = ?, valor_total = ?, data_fechamento = NOW(), observacao = ? WHERE id = ?");
    $stmt->execute([
        $_POST['valor_fechamento'],
        $valor_total,
        $_POST['observacao'] ?? null,
        $_POST['caixa_id']
    ]);

    $_SESSION['success'] = 'Caixa fechado com sucesso!';
} catch (Exception $e) {
    $_SESSION['error'] = $e->getMessage();
}

header('Location: ../caixa.php');
exit;
