<?php
require_once '../config/database.php';
require_once '../includes/auth.php';
header('Content-Type: application/json');

try {
    if (!isset($_POST['id']) || empty($_POST['id'])) {
        throw new Exception('ID do usuário não fornecido');
    }

    $database = new Database();
    $conn = $database->getConnection();
    
    // Verifica se o usuário existe
    $stmt = $conn->prepare("SELECT id FROM usuarios WHERE id = ?");
    $stmt->execute([$_POST['id']]);
    if (!$stmt->fetch()) {
        throw new Exception('Usuário não encontrado');
    }
    
    // Excluir o usuário
    $stmt = $conn->prepare("DELETE FROM usuarios WHERE id = ?");
    $stmt->execute([$_POST['id']]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Usuário excluído com sucesso'
    ]);
    
} catch (Exception $e) {
    error_log("Erro ao excluir usuário: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
