<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

// Garante que não haja output antes do header
header('Content-Type: application/json; charset=utf-8');

try {
    if (empty($_POST['id'])) {
        throw new Exception('ID da categoria é obrigatório');
    }

    $pdo = getConnection();
    
    // Verifica se existem produtos ATIVOS usando esta categoria
    $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM produtos WHERE categoria_id = ? AND deleted_at IS NULL");
    $stmt->execute([$_POST['id']]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($result['total'] > 0) {
        throw new Exception('Não é possível excluir esta categoria pois existem produtos vinculados a ela');
    }
    
    // Faz soft delete da categoria
    $stmt = $pdo->prepare("UPDATE categorias SET deleted_at = NOW() WHERE id = ?");
    if (!$stmt->execute([$_POST['id']])) {
        throw new Exception('Erro ao excluir categoria do banco de dados');
    }
    
    if ($stmt->rowCount() === 0) {
        throw new Exception('Categoria não encontrada');
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Categoria excluída com sucesso'
    ]);

} catch (Exception $e) {
    error_log("Erro ao excluir categoria: " . $e->getMessage());
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
