<?php
require_once '../includes/config.php';

try {
    $db = getConnection();
    
    // Drop tabela existente para recriar
    $db->exec("DROP TABLE IF EXISTS config_site");
    
    // Criar tabela config_site
    $sql = "CREATE TABLE config_site (
        id INT PRIMARY KEY AUTO_INCREMENT,
        site_ativo TINYINT(1) NOT NULL DEFAULT 0,
        ultima_atualizacao TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    $db->exec($sql);
    
    // Inserir configuração padrão
    $sql = "INSERT INTO config_site (site_ativo) VALUES (0)";
    $db->exec($sql);
    
    echo "<div style='font-family: Arial, sans-serif; max-width: 600px; margin: 50px auto; padding: 20px; border-radius: 5px; box-shadow: 0 0 10px rgba(0,0,0,0.1);'>";
    echo "<h2 style='color: #28a745;'>✅ Sucesso!</h2>";
    echo "<p>Tabela <strong>config_site</strong> foi criada com sucesso!</p>";
    echo "<p>Agora você pode voltar para a página de <a href='../configuracoes.php' style='color: #007bff; text-decoration: none;'>configurações</a>.</p>";
    echo "</div>";
    
} catch (PDOException $e) {
    echo "<div style='font-family: Arial, sans-serif; max-width: 600px; margin: 50px auto; padding: 20px; border-radius: 5px; box-shadow: 0 0 10px rgba(0,0,0,0.1); background-color: #fff3cd; border: 1px solid #ffeeba;'>";
    echo "<h2 style='color: #856404;'>⚠️ Erro</h2>";
    echo "<p><strong>Mensagem:</strong> " . $e->getMessage() . "</p>";
    echo "<p>Por favor, verifique se:</p>";
    echo "<ul>";
    echo "<li>O banco de dados existe</li>";
    echo "<li>O usuário tem permissões suficientes</li>";
    echo "<li>A conexão está configurada corretamente</li>";
    echo "</ul>";
    echo "</div>";
}
