<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

try {
    $pdo = getConnection();
    
    // Verifica se existe um caixa aberto para a data atual
    $query = "SELECT id FROM caixa WHERE DATE(data_abertura) = CURDATE() AND data_fechamento IS NULL LIMIT 1";
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    
    $caixaAberto = $stmt->fetch(PDO::FETCH_ASSOC);
    
    die(json_encode([
        'success' => true,
        'caixaAberto' => !empty($caixaAberto)
    ]));
    
} catch (Exception $e) {
    error_log("Erro ao verificar status do caixa: " . $e->getMessage());
    die(json_encode([
        'success' => false,
        'message' => 'Erro ao verificar status do caixa'
    ]));
}
