<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

try {
    if (!isset($_POST['status'])) {
        throw new Exception('Status não fornecido');
    }
    
    // Converte para inteiro (0 ou 1)
    $status = filter_var($_POST['status'], FILTER_VALIDATE_BOOLEAN) ? 1 : 0;
    
    $db = getConnection();
    
    // Atualiza todos os registros (deve ter apenas um)
    $stmt = $db->prepare("UPDATE config_site SET site_ativo = :status");
    $success = $stmt->execute(['status' => $status]);
    
    if (!$success) {
        throw new Exception('Erro ao atualizar status do site');
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Status do site atualizado com sucesso!',
        'site_ativo' => (bool)$status
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
